/*
 *	xfont.h
 */

#ifndef _XFONT_H_
#define _XFONT_H_

#include <gba.h>

#define NBPB		8

#define XF_NAMELEN	3

#define FONT_PATH	"\\system\\fonts"

#pragma pack(1)

/*
 *	font file header
 */

typedef struct _XFONTHEAD {
	u8	sig[2];
	u8	ver;
	u8	size;
	u8	name[XF_NAMELEN+1];
	u16	flags;
	u8	width;
	u8	height;
	u8	xgap;
	u8	ygap;
	u16	unit;
	u16	scode;
	u16	ecode;
	u8	cct;
	u8	reserved[11];
} XFONTHEAD, *PXFONTHEAD;

#define XFONT_SIG	"FF"
#define XFONT_VER	0x01

#define XFF_FIXED	0x0000	// Fixed pitch font
#define XFF_PROP	0x0001	// Proportional font

/*
 *	code conversion table
 */

typedef struct _XCCTHEAD {
	u8	sig[2];
	u8	ver;
	u8	size;
	u8	index;
	u8	reserved[11];
} XCCTHEAD, *PXCCTHEAD;

#define XCCTH_SIG	"CC"
#define XCCTH_VER	0x01

typedef struct _XCCTENT {
	u8	count;
	u8	reserved[3];
} XCCTENT, *PXCCTENT;

#define XCT_SINGLE	0x01
#define XCT_MULTIPLE	0x02

typedef struct _XCCT {
	u8	start;
	u8	end;
	u16	offset;
} XCCT, *PXCCT;

#pragma pack()

/*
 *	Macros
 */

#define FO_SMALL	0
#define FO_NORMAL	1
#define FO_LAST		2

#define ISDBCSFONT(pxf)	(HIBYTE((pxf)->scode) != 0)

/*
 *	font object
 */

typedef struct _XFONTOBJ {
	PXFONTHEAD	pxf;
	void		*pcct;
	int		(*code2index)(struct _XFONTOBJ *pxo, u16 code);
	int		(*getcode)(u8 **ppcode);
} XFONTOBJ, *PXFONTOBJ;

/*
 *	globals
 */

extern int	XfontCodeType[];

/*
 *	functions
 */

/* xfont.c */
BOOL IsValidXfont(PXFONTHEAD pxf);
void XfontSetColor(int fgcolor, int bgcolor);
extern u8 *(*XfontGetFontName)();
extern int (*XfontGetMaxCharWidth)(u8 code);
extern int (*XfontGetCharHeight)();
extern int (*XfontGetCharWidth)(u8 **ppcode);
extern int (*XfontPutChar)(int x, int y, u8 **ppcode);
void XfontInit();

/* xfontobj.c */
void XfontSetFontObject(int index, PXFONTHEAD pxa, PXFONTHEAD pxk);
void XfontSelectFontObject(int index);
PXFONTOBJ XfontGetFontObject(u8 code);

/* xindex.c */
void XfontInitCCT();
void *XfontGetCCT(int index);
int XfontKanjiCode2Index(PXFONTOBJ pxo, u16 code);
int XfontKanaCode2Index(PXFONTOBJ pxo, u16 code);
int XfontAnsiCode2Index(PXFONTOBJ pxo, u16 code);

#endif // _XFONT_H_

