
/*
 *	gba.h
 */

#ifndef _GBA_H_
#define _GBA_H_

/*
 *	type definitions
 */

typedef unsigned char u8;
typedef unsigned short u16;
typedef unsigned long u32;

typedef signed char s8;
typedef signed short s16;
typedef signed long s32;

typedef volatile unsigned char vu8;
typedef volatile unsigned short vu16;
typedef volatile unsigned long vu32;

typedef struct _TRect {
	s32	x, y, w, h;
} TRect, *PTRect;

#ifndef WIN32

#define TRUE		1
#define FALSE		0

typedef int BOOL;

#define min(x, y)	((x) < (y) ? (x) : (y))
#define max(x, y)	((x) > (y) ? (x) : (y))

#define NULL		0

/*** for GCC ***/

#define attriwram __attribute__ ((section (".iwram")))
#define attrinline __attribute__ ((always_inline, const)) static inline

#else	// WIN32

#define attriwram
#define attrinline

#endif	// WIN32

/*
 *	macros
 */

#define WRITE_REG32(r, d) (*(volatile u32 *)(r) = (d))
#define READ_REG32(r) (*(volatile u32 *)(r))
#define WRITE_REG16(r, d) (*(volatile u16 *)(r) = (d))
#define READ_REG16(r) (*(volatile u16 *)(r))

#ifndef WIN32

#define HIBYTE(x)	((u8)(((x) >> 8) & 0xff))
#define LOBYTE(x)	((u8)((x) & 0xff))
#define MAKEWORD(l, h)	(((l) & 0xff) | (((h) << 8) & 0xff00))

#define RGB(r, g, b)	((b) << 10 | (g) << 5 | (r))

#endif	// WIN32

/*
 *	PSR
 */

#define PSR_N		0x80000000
#define PSR_Z		0x40000000
#define PSR_C		0x20000000
#define PSR_V		0x10000000
#define PSR_I		0x00000080
#define PSR_F		0x00000040
#define PSR_T		0x00000020
#define PSR_M		0x0000001f
#define 	PSR_M_USER	0x00000010
#define 	PSR_M_FIQ	0x00000011
#define 	PSR_M_IRQ	0x00000012
#define 	PSR_M_SVC	0x00000013
#define 	PSR_M_ABT	0x00000017
#define 	PSR_M_UND	0x0000001b
#define 	PSR_M_SYSTEM	0x0000001f

/*
 *	RAM
 */

#define EWRAM_ADDR	0x02000000
#define EWRAM_SIZE	(256*1024)

#define IWRAM_ADDR	0x03000000
#define IWRAM_SIZE	(32*1024)

/*
 *	LCD
 */

#define LCD_CTL		0x04000000

/*
 *	Timer
 */

#define TMR_CNT0	0x04000100
#define TMR_CTL0	0x04000102
#define 	TMR_ENABLE	0x0080
#define 	TMR_INTREN	0x0040
#define 	TMR_CASCADE	0x0004
#define 	TMR_1CLOCK	0x0000
#define 	TMR_64CLOCK	0x0001
#define 	TMR_256CLOCK	0x0002
#define 	TMR_1024CLOCK	0x0003

/*
 *	Keypad
 */

#define KEY_STS		0x04000130
#define		KEY_A		0x0001
#define		KEY_B		0x0002
#define		KEY_SELECT	0x0004
#define		KEY_START	0x0008
#define		KEY_RIGHT	0x0010
#define		KEY_LEFT	0x0020
#define		KEY_UP		0x0040
#define		KEY_DOWN	0x0080
#define		KEY_R		0x0100
#define		KEY_L		0x0200
#define		KEY_ALL		0x03ff
#define KEY_CTL		0x04000132
#define		KEY_INTENA	0x4000
#define		KEY_INTAND	0x8000

/*
 *	Interrupt
 */

#define INT_IE		0x04000200
#define INT_IF		0x04000202
#define 	INT_TMR0	0x0008
#define 	INT_KEYPAD	0x1000
#define INT_IME		0x04000208
#define 	INT_IME_OFF	0x0000
#define 	INT_IME_ON	0x0001

#define INT_VECTOR	0x03007ffc

/*
 *	DMA
 */

#define REG_DM0SAD      0x40000B0
#define REG_DM0SAD_L    0x40000B0
#define REG_DM0SAD_H    0x40000B2
#define REG_DM0DAD      0x40000B4
#define REG_DM0DAD_L    0x40000B4
#define REG_DM0DAD_H    0x40000B6
#define REG_DM0CNT      0x40000B8
#define REG_DM0CNT_L    0x40000B8
#define REG_DM0CNT_H    0x40000BA
#define REG_DM1SAD      0x40000BC
#define REG_DM1SAD_L    0x40000BC
#define REG_DM1SAD_H    0x40000BE
#define REG_DM1DAD      0x40000C0
#define REG_DM1DAD_L    0x40000C0
#define REG_DM1DAD_H    0x40000C2
#define REG_DM1CNT      0x40000C4
#define REG_DM1CNT_L    0x40000C4
#define REG_DM1CNT_H    0x40000C6
#define REG_DM2SAD      0x40000C8
#define REG_DM2SAD_L    0x40000C8
#define REG_DM2SAD_H    0x40000CA
#define REG_DM2DAD      0x40000CC
#define REG_DM2DAD_L    0x40000CC
#define REG_DM2DAD_H    0x40000CE
#define REG_DM2CNT      0x40000D0
#define REG_DM2CNT_L    0x40000D0
#define REG_DM2CNT_H    0x40000D2
#define REG_DM3SAD      0x40000D4
#define REG_DM3SAD_L    0x40000D4
#define REG_DM3SAD_H    0x40000D6
#define REG_DM3DAD      0x40000D8
#define REG_DM3DAD_L    0x40000D8
#define REG_DM3DAD_H    0x40000DA
#define REG_DM3CNT      0x40000DC
#define REG_DM3CNT_L    0x40000DC
#define REG_DM3CNT_H    0x40000DE

/*
 *	Color Palette
 */

#define PAL_ADDR	0x05000000

/*
 *	VRAM
 */

#define VRAM_ADDR	0x06000000

#define SCREEN_WIDTH	240
#define SCREEN_HEIGHT	160

/*
 *	ROM
 */

#define ROM_ADDR	0x08000000
#define ROM_SIZE	(32*1024*1024)

/*
 *	SRAM
 */

#define SRAM_ADDR	0x0e000000
#define SRAM_SIZE	(64*1024)

#endif // _GBA_H_

