#ifndef __KEY_H__
#define __KEY_H__
#ifdef __cplusplus
extern "C" {
#endif


#include "../libgba/gba.h"

//---------------------------------------------------------------------------
#define KEY_REPEAT_1ST_CNT		20
#define KEY_REPEAT_2ST_CNT		2


//---------------------------------------------------------------------------

typedef struct {
	u32  cnt;					// ݂̃L[
	u32  trg;					// ꂽL[
	u32  off;					// ꂽL[
	u32  rep;					// s[gL[
	s32  repCnt;				// s[gJEg
	bool isRep;					// s[gJEg̍ŏL
} ST_KEY;


//---------------------------------------------------------------------------
EWRAM_CODE void KeyInit(void);
IWRAM_CODE void KeyExec(void);

EWRAM_CODE u32  KeyGetCnt(void);
EWRAM_CODE u32  KeyGetTrg(void);
EWRAM_CODE u32  KeyGetOff(void);
EWRAM_CODE u32  KeyGetRep(void);


#ifdef __cplusplus
}
#endif
#endif
