#ifndef __GBFS_H__
#define __GBFS_H__
#ifdef __cplusplus
extern "C" {
#endif

#include "gba.h"


//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// wb_i32oCgj
typedef struct {
	char sig[16];				// VOl` "PinEightGBFS" + 0x0d + 0x0a + 0x1a + 0x0a
	u32  size;					// A[JCȗ傫
	u16  dirOff;				// t@Cꗗ̃ItZbg(ROMI[̑)
	u16  fileCnt;				// t@C̓o^
	u8   noUse[8];				// 󂫗̈
} __PACKED ST_GBFS_HEADER;


// t@CXgi32oCgj
typedef struct {
	char fname[24];				// t@C
	u32  size;					// TCY
	u32  dataOff;				// t@C̃ItZbg(ROMI[̑)
} __PACKED ST_GBFS_LIST;


typedef struct {
	ST_GBFS_HEADER* pHeader;
	ST_GBFS_LIST*   pList;
	u32             pos;
} ST_GBFS;

//---------------------------------------------------------------------------
EWRAM_CODE void  GbfsInit(void);

IWRAM_CODE void* GbfsGetPointer(char* fname);
IWRAM_CODE void* GbfsGetPointer2(s32 cnt);
IWRAM_CODE void* GbfsGetSafePointer(char* fname);
IWRAM_CODE void* GbfsGetSafePointer2(s32 cnt);

EWRAM_CODE char* GbfsGetFileName(void);
EWRAM_CODE u32   GbfsGetFileSize(void);
EWRAM_CODE s32   GbfsGetArcSize(void);
EWRAM_CODE s32   GbfsGetArcCnt(void);


#ifdef __cplusplus
}
#endif
#endif
